#!/bin/bash
#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#
#  $Id: uninstall.sh 9052 2006-08-22 13:40:13Z vlad $
#
# A script to uninstall OpenIB stack
#

usage() 
{
cat << EOF

        Usage: ${prog} [--force]

EOF
}

prog=`basename $0`
FORCE=0
while [ ! -z "$1" ]
do
        case $1 in
                --force)
                FORCE=1
                shift
                ;;
                *)
                usage
                exit 1
                ;;
        esac
done

# Find the directory where this script resides
installdir=`cd ${0%*/*};pwd`
prefix=${installdir}
KVERSION=${KVERSION:-$(uname -r)}
INFO=/etc/infiniband/info

if [ $UID -ne 0 ]; then
        echo You must be root to install OpenIb stack
        exit 1
fi

# Check prefix and kernel version using info file:
if [ -x ${INFO} ]; then
        info_prefix=$(${INFO} | grep -w prefix | cut -d '=' -f 2)
        info_kversion=$(${INFO} | grep "^Kernel=" | cut -d '=' -f 2)

        if [ "X${info_prefix}" != "X${prefix}" ]; then
                # uninstall.sh was executed not from $prefix directory
                echo "WARNING: The OpenIB stack prefix will be changed from ${prefix} to ${info_prefix}."
                prefix=${info_prefix}
        fi

        if [ "X${KVERSION}" != "X${info_kversion}" ]; then
                # OpenIB stack was installed for different from current kernel          
                echo "WARNING: The OpenIB stack kernel will be changed from ${KVERSION} to ${info_kversion}."
                KVERSION=${info_kversion}
        fi
fi

KVERSION_TWO_DIGITS=2$(echo ${KVERSION} | cut -d"." -f2)
KSRC=/lib/modules/${KVERSION}/build
KERNEL_SOURCES=/lib/modules/${KVERSION}/source
LIB_MOD_DIR=/lib/modules/${KVERSION}/kernel/drivers/infiniband

cat << EOF

        This will uninstall the following components:
                1. HCA HW Driver and ULPs from ${LIB_MOD_DIR}
                2. User level libraries from ${prefix}

EOF

if [ ${FORCE} -eq 0 ]; then
        read -p "Do you want to continue (y/n) [y] ?" force
        case ${force} in
                y|yes|YES|"")
                        echo "Proceeding with uninstall process..."
                ;;
                *)
                        echo "Aborting uninstallation."
                        exit 1
                ;;
        esac
fi

if ( /etc/init.d/openibd status > /dev/null 2>&1 ); then
        echo "Trying to unload modules (/etc/init.d/openibd stop). Please wait..."
        /etc/init.d/openibd stop
        if [ $? -ne 0 ]; then
                echo "Failed to unload modules."
                if [ ${FORCE} -eq 0 ]; then
                        read -p "Do you want to continue (y/n) [y] ?" force
                        case ${force} in
                                y|yes|YES|"")
                                        echo "Proceeding with uninstall process..."
                                ;;
                                *)
                                        echo "Aborting uninstallation."
                                        echo "First unload modules (/etc/init.d/openibd stop), then rerun uninstall.sh"
                                        exit 1
                                ;;
                        esac
                fi
        fi
fi

/bin/rm -f /etc/dat.conf

# #Clean temporary directories
# /bin/rm -rf /tmp/openib_gen2

cd ${CWD}

# Disable services and remove configuration files
rm -rf /etc/infiniband

if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then        
     /sbin/chkconfig openibd off > /dev/null 2>&1
     /sbin/chkconfig opensmd off > /dev/null 2>&1
     rm -f /etc/sysconfig/network-scripts/ifcfg-ib*
fi
if [ -f /etc/SuSE-release ]; then
     /sbin/insserv -r openibd > /dev/null 2>&1
     /sbin/insserv -r opensmd > /dev/null 2>&1
     rm -f /etc/sysconfig/network/ifcfg-ib*
fi
if [ -f /etc/debian_version ]; then
     /usr/sbin/update-rc.d openibd remove > /dev/null 2>&1
     /usr/sbin/update-rc.d opensmd remove > /dev/null 2>&1
     perl -ni -e 'if (/\#\#\# IPoIB \#\#\#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\#\#\# END IPoIB \#\#\#$/){ $filter = 0 }' /etc/network/interfaces
fi

/bin/rm -f /etc/init.d/openibd
/bin/rm -f /etc/init.d/opensmd

/bin/rm -f /etc/opensm.conf
/bin/rm -f /etc/udev/rules.d/90-ib.rules

#########################################################################
#              Restore Gen2 original sources and include files          #
#########################################################################

if [ -f ${prefix}/backup/infiniband-${KVERSION}.tgz ]; then
        rm -rf ${KERNEL_SOURCES}/drivers/infiniband
        tar xzfP ${prefix}/backup/infiniband-${KVERSION}.tgz
        /bin/rm -f ${prefix}/backup/infiniband-${KVERSION}.tgz
fi

if [ -f ${prefix}/backup/infiniband_ko-${KVERSION}.tgz ]; then
        /bin/rm -rf ${LIB_MOD_DIR}
        tar xzfP ${prefix}/backup/infiniband_ko-${KVERSION}.tgz
        /bin/rm -f ${prefix}/backup/infiniband_ko-${KVERSION}.tgz
        /sbin/depmod -r -ae ${KVERSION}
fi

if [ -f ${prefix}/backup/rdma-${KVERSION}.tgz ]; then
        rm -rf ${KERNEL_SOURCES}/include/rdma
        tar xzfP ${prefix}/backup/rdma-${KVERSION}.tgz
        /bin/rm -f ${prefix}/backup/rdma-${KVERSION}.tgz
fi

if [ -f ${prefix}/backup/srp-${KVERSION}.h ]; then
        rm -f ${KERNEL_SOURCES}/include/scsi/srp.h
        mv ${prefix}/backup/srp-${KVERSION}.h ${KERNEL_SOURCES}/include/scsi/srp.h
fi

# Remove kernel modules from updates directory
rm -rf /lib/modules/${KVERSION}/updates/kernel/drivers/infiniband
rm -rf /lib/modules/${KVERSION}/updates/kernel/drivers/net/mlx4
rm -rf /lib/modules/${KVERSION}/updates/kernel/drivers/net/cxgb3
rm -rf /lib/modules/${KVERSION}/updates/kernel/net/rds

#########################################################################
#                           Restore Done                                #
#########################################################################


/sbin/depmod -ae ${KVERSION}

# Remove files from prefix
if [ "$(uname -m)" == "x86_64" ] || [ "$(uname -m)" == "ppc64" ]; then
        LIB_DIRS="${prefix}/lib ${prefix}/lib64"
else
        LIB_DIRS=${prefix}/lib
fi

# Remove files from 'prefix'/bin
/bin/rm -f ${prefix}/bin/ibv_*
/bin/rm -f ${prefix}/bin/uats
/bin/rm -f ${prefix}/bin/uatt
/bin/rm -f ${prefix}/bin/ib_*
/bin/rm -f ${prefix}/bin/ibcheck*
/bin/rm -f ${prefix}/bin/ibclear*
/bin/rm -f ${prefix}/bin/runme
/bin/rm -f ${prefix}/bin/mstmread
/bin/rm -f ${prefix}/bin/mstmwrite
/bin/rm -f ${prefix}/bin/mstflint
/bin/rm -f ${prefix}/bin/mstregdump
/bin/rm -f ${prefix}/bin/mstvpd
/bin/rm -f ${prefix}/bin/sdpnetstat
# Diags
/bin/rm -f ${prefix}/bin/ibaddr
/bin/rm -f ${prefix}/bin/ibnetdiscover
/bin/rm -f ${prefix}/bin/ibping
/bin/rm -f ${prefix}/bin/ibroute
/bin/rm -f ${prefix}/bin/ibstat
/bin/rm -f ${prefix}/bin/ibsysstat
/bin/rm -f ${prefix}/bin/ibtracert
/bin/rm -f ${prefix}/bin/perfquery
/bin/rm -f ${prefix}/bin/sminfo
/bin/rm -f ${prefix}/bin/smpquery
/bin/rm -f ${prefix}/bin/smpdump
/bin/rm -f ${prefix}/bin/ibchecknet
/bin/rm -f ${prefix}/bin/ibchecknode
/bin/rm -f ${prefix}/bin/ibcheckerrors
/bin/rm -f ${prefix}/bin/ibcheckport
/bin/rm -f ${prefix}/bin/ibhosts
/bin/rm -f ${prefix}/bin/ibstatus
/bin/rm -f ${prefix}/bin/ibswitches
/bin/rm -f ${prefix}/bin/opensm
/bin/rm -f ${prefix}/bin/osmtest
/bin/rm -f ${prefix}/bin/dump_lfts.sh
/bin/rm -f ${prefix}/bin/dump_mfts.sh
/bin/rm -f ${prefix}/bin/ibdiscover.pl
/bin/rm -f ${prefix}/bin/ibnodes
/bin/rm -f ${prefix}/bin/ibportstate
/bin/rm -f ${prefix}/bin/ipoib_ha.pl
/bin/rm -f ${prefix}/bin/mcasthandle
/bin/rm -f ${prefix}/bin/rping
/bin/rm -f ${prefix}/bin/saquery
/bin/rm -f ${prefix}/bin/set_mthca_nodedesc.sh
/bin/rm -f ${prefix}/bin/ucmatose
/bin/rm -f ${prefix}/bin/ibfindnodesusing.pl
/bin/rm -f ${prefix}/bin/iblinkspeed.pl
/bin/rm -f ${prefix}/bin/iblinkinfo.pl
/bin/rm -f ${prefix}/bin/ibprintca.pl
/bin/rm -f ${prefix}/bin/ibprintswitch.pl
/bin/rm -f ${prefix}/bin/ibqueryerrors.pl
/bin/rm -f ${prefix}/bin/ibswportwatch.pl
/bin/rm -f ${prefix}/bin/mckey
/bin/rm -f ${prefix}/bin/udaddy
/bin/rm -f ${prefix}/bin/vendstat
/bin/rmdir ${prefix}/bin > /dev/null 2>&1

# Remove files from 'prefix'/sbin
/bin/rm -f ${prefix}/sbin/ibsrpdm
/bin/rm -f ${prefix}/sbin/run_srp_daemon
/bin/rm -f ${prefix}/sbin/srp_daemon
/bin/rm -f ${prefix}/sbin/srp_daemon.sh
/bin/rm -f ${prefix}/sbin/tvflash
/bin/rm -f ${prefix}/sbin/ibvexdm
/bin/rm -f ${prefix}/sbin/vnic_parser.pl
/bin/rm -f ${prefix}/sbin/ha
/bin/rm -f ${prefix}/sbin/ipoibarping
/bin/rmdir ${prefix}/sbin > /dev/null 2>&1

# Remove man pages
/bin/rm -f ${prefix}/man/man1/*ibv_*
/bin/rm -f ${prefix}/man/man1/ibsrpdm*
/bin/rm -f ${prefix}/man/man1/srp_daemon*
/bin/rmdir ${prefix}/man/man1 > /dev/null 2>&1

/bin/rm -f ${prefix}/man/man3/*ibv_*
/bin/rmdir ${prefix}/man/man3 > /dev/null 2>&1

/bin/rm -f ${prefix}/man/man8/dump_lfts*
/bin/rm -f ${prefix}/man/man8/ibaddr*
/bin/rm -f ${prefix}/man/man8/ibcheck*
/bin/rm -f ${prefix}/man/man8/ibclear*
/bin/rm -f ${prefix}/man/man8/ibdiscover*
/bin/rm -f ${prefix}/man/man8/ibhosts*
/bin/rm -f ${prefix}/man/man8/ibnetdiscover*
/bin/rm -f ${prefix}/man/man8/ibnodes*
/bin/rm -f ${prefix}/man/man8/ibping*
/bin/rm -f ${prefix}/man/man8/ibportstate*
/bin/rm -f ${prefix}/man/man8/ibroute*
/bin/rm -f ${prefix}/man/man8/ibstat*
/bin/rm -f ${prefix}/man/man8/ibstatus*
/bin/rm -f ${prefix}/man/man8/ibswitches*
/bin/rm -f ${prefix}/man/man8/ibsysstat*
/bin/rm -f ${prefix}/man/man8/ibtracert*
/bin/rm -f ${prefix}/man/man8/opensm*
/bin/rm -f ${prefix}/man/man8/osmtest*
/bin/rm -f ${prefix}/man/man8/perfquery*
/bin/rm -f ${prefix}/man/man8/saquery*
/bin/rm -f ${prefix}/man/man8/sminfo*
/bin/rm -f ${prefix}/man/man8/smpdump*
/bin/rm -f ${prefix}/man/man8/smpquery*
/bin/rm -f ${prefix}/man/man8/ibfindnodesusing*
/bin/rm -f ${prefix}/man/man8/iblinkspeed*
/bin/rm -f ${prefix}/man/man8/ibprintca*
/bin/rm -f ${prefix}/man/man8/ibprintswitch*
/bin/rm -f ${prefix}/man/man8/ibqueryerrors*
/bin/rm -f ${prefix}/man/man8/ibswportwatch*
/bin/rm -f ${prefix}/man/man8/vendstat*
/bin/rm -f ${prefix}/man/man8/dump_mfts*
/bin/rm -f ${prefix}/man/man8/iblinkinfo*

/bin/rmdir ${prefix}/man/man8 > /dev/null 2>&1

/bin/rmdir ${prefix}/man > /dev/null 2>&1

# Remove include files
/bin/rm -f ${prefix}/include/mtcr.h
/bin/rm -rf ${prefix}/include/infiniband
/bin/rm -rf ${prefix}/include/rdma
/bin/rmdir ${prefix}/include > /dev/null 2>&1

for LIB_DIR in ${LIB_DIRS}
do
        # Remove userspace libraries
        /bin/rm -f ${LIB_DIR}/libibverbs*
        /bin/rm -f ${LIB_DIR}/libibcm*
        /bin/rm -f ${LIB_DIR}/libsdp*
        /bin/rm -f ${LIB_DIR}/librdmacm*
        /bin/rm -rf ${LIB_DIR}/infiniband
        /bin/rm -f ${LIB_DIR}/libmthca*
        /bin/rm -f ${LIB_DIR}/libmlx4*
        /bin/rm -f ${LIB_DIR}/libcxgb3*
        # Management
        /bin/rm -f ${LIB_DIR}/libibcommon*
        /bin/rm -f ${LIB_DIR}/libibumad*
        /bin/rm -f ${LIB_DIR}/libibmad*
        /bin/rm -f ${LIB_DIR}/libosm*
        /bin/rm -f ${LIB_DIR}/libopensm*
        /bin/rm -f ${LIB_DIR}/perl/IBswcountlimits.pm

        /bin/rmdir ${LIB_DIR}/perl > /dev/null 2>&1
        /bin/rmdir ${LIB_DIR} > /dev/null 2>&1
done

/bin/rm -f ${prefix}/etc/libsdp.conf
/bin/rm -rf ${prefix}/etc/libibverbs.d
/bin/rmdir ${prefix}/etc > /dev/null 2>&1

/bin/rm -f ${prefix}/BUILD_ID

if [ -d ${prefix}/src/openib ]; then
    pushd ${prefix}/src > /dev/null 2>&1
    rm -rf gen2_devel*  gen2_linux* openib* connectx* ofa*
    popd > /dev/null 2>&1
fi
/bin/rmdir ${prefix}/src > /dev/null 2>&1

/bin/rm -f /etc/profile.d/ofed.sh
/bin/rm -f /etc/profile.d/ofed.csh
/bin/rm -f /etc/ld.so.conf.d/ofed.conf
# /bin/rm -f /etc/srp_daemon.conf
/sbin/ldconfig > /dev/null 2>&1

perl -ni -e "print unless (/ib_mthca/)" /etc/modprobe.conf
perl -ni -e "print unless (/ib_ipoib/)" /etc/modprobe.conf
perl -ni -e "print unless (/ib_sdp/)" /etc/modprobe.conf
if [ -e /etc/udev/udev.rules ]; then
    perl -ni -e 'if (/\# Infiniband devices \#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\# End Infiniband devices \#$/){ $filter = 0 }' /etc/udev/udev.rules
fi

/bin/rm -f $0

# Check if prefix is a part of a Linux distribution (/usr, ...)
case ${prefix//\//} in
        usr|usrlocal|opt|bin|etc|lib|lib64|local|misc|sbin|var|boot|root|""|tmp|home*)
        ;;
        *)
        /bin/rmdir ${prefix} > /dev/null 2>&1
        ;;
esac

echo "OpenIB stack uninstalled successfully."
exit 0
